//
//  SurveySmartphoneUsageFinalViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 27.06.23.
//

import Foundation
import UIKit
import Firebase

class SurveySmartphoneUsageFinalViewController: UIViewController {


    @IBOutlet var homeButton: UIButton!

    @IBOutlet var progressBarView: UIProgressView!

    @IBOutlet var continueButton: UIButton!

    @IBOutlet var logoImage: UIImageView!

    @IBOutlet var finalWords: UILabel!


    override func viewDidLoad() {
        super.viewDidLoad()

        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        homeButton.backgroundColor = UIColor.clear
        homeButton.setImage(UIImage(systemName: "homeButton"), for: .normal)
        homeButton.tintColor = UIColor.init(red: 169.0/255.0, green: 1/255.0, blue: 25/255.0, alpha: 1.0)

        homeButton.frame.size = CGSize(width: 15, height: 15)
        homeButton.addTarget(self, action: #selector(pressedHomeButton(_ :)), for: .touchUpInside)

        logoImage.alpha = 0.1

        progressBarView.progress = 1

        finalWords.font = UIFont(name: "Avenir-Medium", size: 17) ?? UIFont.systemFont(ofSize: 17)
        
        Utilities.styleFilledButtonBackToStudyOverviewRede(continueButton)
        
        
        
        // send data to firestore database!
        let db = Firestore.firestore()

        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ"
        let timestampAppTransactionTimestamp = dateFormatter.string(from: Date())
        let timestampAppTransactionString = String(timestampAppTransactionTimestamp)
        print("Timestamp App Transaction: \(timestampAppTransactionString)")
        
        db.collection(survey_SmartphoneUsageDBPublic).addDocument(data: ["Q1" : study_SmartphoneUsageuserAnswersPublic[0], "Q2" : study_SmartphoneUsageuserAnswersPublic[1], "Q3" : study_SmartphoneUsageuserAnswersPublic[2], "Q4" : study_SmartphoneUsageuserAnswersPublic[3], "Q5" : study_SmartphoneUsageuserAnswersPublic[4], "Q6" : study_SmartphoneUsageuserAnswersPublic[5], "Q7" : study_SmartphoneUsageuserAnswersPublic[6], "Q8" : study_SmartphoneUsageuserAnswersPublic[7], "Q9" : study_SmartphoneUsageuserAnswersPublic[8], "Q10" : study_SmartphoneUsageuserAnswersPublic[9], "timestamp_Qualtrics" : timestamp_QualtricsPublic]) { (error) in
                        
        if(error != nil) {
            print("Error saving user answers in Firestore DB :-(")
        }
        }
        print("Done. Saved user answers successfully in Firestore DB!")
        
        
        
    }

    @objc func pressedHomeButton(_ sender: UIButton) {
        print("Home Button Pressed")

        study_SmartphoneUsageuserAnswersPublic = []
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController

        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
    }

    @IBAction func continueButton(_ sender: Any) {

        study_SmartphoneUsageuserAnswersPublic = []
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController

        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()

    }
}
